/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.plugin;

import de.willuhn.io.FileFinder;
import de.willuhn.jameica.plugin.AbstractPluginSource;
import de.willuhn.jameica.plugin.PluginSource;
import de.willuhn.jameica.services.SecurityManagerService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.io.File;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

public class PluginSourceSystem
extends AbstractPluginSource {
    private List<File> dirs = null;

    @Override
    public PluginSource.Type getType() {
        return PluginSource.Type.SYSTEM;
    }

    @Override
    public synchronized List<File> find() {
        File[] pluginDirs;
        if (this.dirs != null) {
            return this.dirs;
        }
        this.dirs = new ArrayList<File>();
        File dir = this.getDir();
        Logger.info((String)("searching for " + this.getType() + " plugins in " + dir.getAbsolutePath()));
        for (File pluginDir : pluginDirs = new FileFinder(dir).findAll()) {
            if (!pluginDir.canRead() || !pluginDir.isDirectory()) {
                Logger.warn((String)("  skipping " + pluginDir.getAbsolutePath() + " - no directory or not readable"));
                continue;
            }
            Logger.info((String)("  adding " + pluginDir.getAbsolutePath()));
            this.dirs.add(pluginDir);
        }
        return this.dirs;
    }

    @Override
    public boolean canWrite() {
        SecurityManagerService s = (SecurityManagerService)Application.getBootLoader().getBootable(SecurityManagerService.class);
        final File dir = this.getDir();
        Boolean b = s.getSecurityManager().doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (!dir.exists()) {
                    Logger.warn((String)("system plugin dir " + dir + " does not exist, try to create"));
                    File parent = dir.getParentFile();
                    if (!parent.canWrite()) {
                        Logger.warn((String)("unable to create - no write permissions in " + parent));
                        return false;
                    }
                    if (!dir.mkdir()) {
                        Logger.warn((String)("unable to create dir " + dir));
                        return false;
                    }
                    Logger.info((String)("created dir " + dir));
                    return true;
                }
                return dir.canWrite();
            }

            public String toString() {
                return "writable check for " + dir;
            }
        });
        return b;
    }

    @Override
    public String getName() {
        return Application.getI18n().tr("Programm-Ordner (f\u00fcr alle Benutzer der Jameica-Installation)");
    }

    @Override
    public File getDir() {
        return Application.getConfig().getSystemPluginDir();
    }
}

